//
//  NSString+BadgeDrawing.h
//  GlyphsCore
//
//  Created by Georg Seifert on 01.05.16.
//  Copyright © 2016 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <GlyphsCore/GSGeometrieHelper.h>

@class GSLayer;

NS_ASSUME_NONNULL_BEGIN

@interface NSString (BadgeDrawing)

// to make it accessible in Scripts
/**
 This returns the font size depending on the handleSize. It can be '0', '1', and '2'. To get the default value as set in Preferences, use '-1'
 */
+ (CGFloat)fontSizeForHandleSize:(int)handleSize;

+ (NSDictionary *)drawTextAttributes:(nullable NSColor *)textColor fontSize:(nullable CGFloat *)fontSize;

- (void)drawBadgeAtPoint:(NSPoint)position alignment:(GSAlignment)alignment;

- (void)drawBadgeAtPoint:(NSPoint)drawPoint alignment:(GSAlignment)alignment color:(nullable NSColor *)color;

- (NSRect)drawBadgeAtPoint:(NSPoint)position size:(CGFloat)textSize color:(nullable NSColor *)color backgroundColor:(nullable NSColor *)backgroundColor alignment:(GSAlignment)alignment visibleInRect:(NSRect)visibleRect;

- (NSRect)drawAtPoint:(NSPoint)position color:(nullable NSColor *)textColor alignment:(GSAlignment)alignment handleSize:(int)handleSize;

- (NSRect)drawAtPoint:(NSPoint)drawPoint color:(NSColor *)textColor alignment:(GSAlignment)alignment fontSize:(CGFloat)fontSize;

- (CGFloat)drawAtPoint:(CGPoint)basePoint angle:(CGFloat)angle offset:(CGFloat)offset handleSize:(int)handleSize color:(nullable NSColor *)color alignment:(GSAlignment)alignment;

- (NSRect)rectForBadgeAtPoint:(NSPoint)drawPoint alignment:(GSAlignment)alignment visibleInRect:(NSRect)visibleRect;

- (void)drawBadgeInRect:(NSRect)badgeRect active:(BOOL)active;

@end

@interface NSAttributedString (BadgeDrawing)

- (NSRect)drawAtPoint:(NSPoint)position alignment:(GSAlignment)alignment;

- (void)drawFittedInRect:(NSRect)frame;

@end

NS_ASSUME_NONNULL_END
